// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/devices_app/usb/public/interfaces/device.mojom
//

package org.chromium.mojom.device.usb;

public final class DeviceInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 72;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(72, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public String guid;
    public byte usbVersionMajor;
    public byte usbVersionMinor;
    public byte usbVersionSubminor;
    public byte classCode;
    public byte subclassCode;
    public byte protocolCode;
    public short vendorId;
    public short productId;
    public byte deviceVersionMajor;
    public byte deviceVersionMinor;
    public byte deviceVersionSubminor;
    public String manufacturerName;
    public String productName;
    public String serialNumber;
    public ConfigurationInfo[] configurations;
    public WebUsbDescriptorSet webusbAllowedOrigins;

    private DeviceInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public DeviceInfo() {
        this(0);
    }

    public static DeviceInfo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static DeviceInfo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        DeviceInfo result = new DeviceInfo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.guid = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.usbVersionMajor = decoder0.readByte(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.usbVersionMinor = decoder0.readByte(17);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.usbVersionSubminor = decoder0.readByte(18);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.classCode = decoder0.readByte(19);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.subclassCode = decoder0.readByte(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.protocolCode = decoder0.readByte(21);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.vendorId = decoder0.readShort(22);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.productId = decoder0.readShort(24);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.deviceVersionMajor = decoder0.readByte(26);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.deviceVersionMinor = decoder0.readByte(27);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.deviceVersionSubminor = decoder0.readByte(28);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.manufacturerName = decoder0.readString(32, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.productName = decoder0.readString(40, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.serialNumber = decoder0.readString(48, true);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
            {
                org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.configurations = new ConfigurationInfo[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    result.configurations[i1] = ConfigurationInfo.decode(decoder2);
                }
            }
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, true);
            result.webusbAllowedOrigins = WebUsbDescriptorSet.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(guid, 8, false);
        encoder0.encode(usbVersionMajor, 16);
        encoder0.encode(usbVersionMinor, 17);
        encoder0.encode(usbVersionSubminor, 18);
        encoder0.encode(classCode, 19);
        encoder0.encode(subclassCode, 20);
        encoder0.encode(protocolCode, 21);
        encoder0.encode(vendorId, 22);
        encoder0.encode(productId, 24);
        encoder0.encode(deviceVersionMajor, 26);
        encoder0.encode(deviceVersionMinor, 27);
        encoder0.encode(deviceVersionSubminor, 28);
        encoder0.encode(manufacturerName, 32, true);
        encoder0.encode(productName, 40, true);
        encoder0.encode(serialNumber, 48, true);
        if (configurations == null) {
            encoder0.encodeNullPointer(56, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(configurations.length, 56, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < configurations.length; ++i0) {
                encoder1.encode(configurations[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        encoder0.encode(webusbAllowedOrigins, 64, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        DeviceInfo other = (DeviceInfo) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.guid, other.guid))
            return false;
        if (this.usbVersionMajor != other.usbVersionMajor)
            return false;
        if (this.usbVersionMinor != other.usbVersionMinor)
            return false;
        if (this.usbVersionSubminor != other.usbVersionSubminor)
            return false;
        if (this.classCode != other.classCode)
            return false;
        if (this.subclassCode != other.subclassCode)
            return false;
        if (this.protocolCode != other.protocolCode)
            return false;
        if (this.vendorId != other.vendorId)
            return false;
        if (this.productId != other.productId)
            return false;
        if (this.deviceVersionMajor != other.deviceVersionMajor)
            return false;
        if (this.deviceVersionMinor != other.deviceVersionMinor)
            return false;
        if (this.deviceVersionSubminor != other.deviceVersionSubminor)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.manufacturerName, other.manufacturerName))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.productName, other.productName))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.serialNumber, other.serialNumber))
            return false;
        if (!java.util.Arrays.deepEquals(this.configurations, other.configurations))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.webusbAllowedOrigins, other.webusbAllowedOrigins))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(guid);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(usbVersionMajor);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(usbVersionMinor);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(usbVersionSubminor);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(classCode);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(subclassCode);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(protocolCode);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(vendorId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(productId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(deviceVersionMajor);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(deviceVersionMinor);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(deviceVersionSubminor);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(manufacturerName);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(productName);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(serialNumber);
        result = prime * result + java.util.Arrays.deepHashCode(configurations);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(webusbAllowedOrigins);
        return result;
    }
}

